<?php
/***************************************************************************
 *
 *  Author: Dennis 'Kapsonfire' Kaspar
 *  Website: http://www.pokecom.eu
 *	Mail: kapsonfire-at-gmx-dot-de
 *
 ***************************************************************************/
 
 /****************************************************************************
	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
****************************************************************************/

if(!defined("IN_MYBB"))
{
	die("Outside of MyBB");
}
$plugins->add_hook('global_end','kapsfavicon_hook');


function kapsfavicon_info()
{

	return array(
		"name"			=> "هاك تغيير صورة Favicon",
		"description"	=> "تستطيع من خلاله تغيير الصورة واضافة صورة خاصه",
		"website"		=> "http://mods.mybb.com",
		"author"		=> "Kapsonfire",
		"authorsite"	=> "http://www.pokecom.eu",
		"guid"          => "270ab0cb80e5ff66d5960f46a1f9a517",
		"version"		=> "0.1",
		"compatibility" => "16*"
	);
}

function kapsfavicon_activate()
{
	global $db;
	require '../inc/adminfunctions_templates.php';
	
	$query  = $db->simple_select("settinggroups","COUNT(*) as rows");
	$rows   = $db->fetch_field($query,"rows");
	$iad_group = array('name' => 'kapsfavicon','title' => 'هاك تغيير صورة Favicon','description' => 'اعدادات الهاك','disporder' =>$rows + 1,'isdefault' => '0',);
	$db->insert_query('settinggroups',$iad_group);
	$gid = $db->insert_id();
	
	//onoff
	$setting1	   = array('name' => 'KAPS-FAV-Activate',
						   'title' =>'تفعيل / تعطيل',
						   'description' =>'تستطيع تفعيل او تعطيل الهاك',
						   'optionscode' => 'onoff',
						   'value' => '0',
						   'disporder' => 1,
						   'gid' => intval($gid),);
	//adresse					   
	$setting2	   = array('name' => 'KAPS-FAV-Location',
						   'title' =>'مسار الصورة',
						   'description' =>'ضع مسار الصورة المراد اظهارها او ضع رابط مباشر لها',
						   'optionscode' => 'text',
						   'value' => 'favicon.ico',
						   'disporder' => 2,
						   'gid' => intval($gid),);
	$db->insert_query('settings',$setting1);
    $db->insert_query('settings',$setting2);
	rebuildsettings();
						   
						   
    
}

function kapsfavicon_deactivate()
{
	
    global $db;
	require MYBB_ROOT.'/inc/adminfunctions_templates.php';
	
	
    $db->query("DELETE FROM ".TABLE_PREFIX."templates WHERE title='Clean Favicon'");
    $db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name IN('KAPS-FAV-Activate', 'kapsfavicon')");
    $db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name IN('KAPS-FAV-Location', 'kapsfavicon')");
    $db->query("DELETE FROM ".TABLE_PREFIX."settinggroups WHERE name='kapsfavicon'");
	rebuildsettings();
}
function kapsValidIcon($str)
{
	$str=strtolower($str);
	if($str=='ico'||$str=='png'||$str=='gif') return true;
	return false;
	
}
function kapsGetIconFormat($str)
{
	$str=strtolower($str);
	if($str=='ico')
	{
		return 'image/x-icon';
	}
	else if($str=='png')
	{
		return 'image/png';
	}
	else if($str=='gif')
	{
		return 'image/gif';
	}
	return '';
	
	
}
function kapsfavicon_hook()
{
	global $headerinclude, $mybb;
	
	$str = explode('.',$mybb->settings['KAPS-FAV-Location']);
	$for = $str[count($str)-1];
	
	
	if(intval($mybb->settings['KAPS-FAV-Activate']))
	{
		if(kapsValidIcon($for))
		{
			$headerinclude .= '<link type="'.kapsGetIconFormat($for).'" rel="icon" href="'.$mybb->settings['KAPS-FAV-Location'].'" />';
		}
		else
		{
			$headerinclude .= '<!--- INVALID FAVICON !--->';
		}
	}
	
}


?>